function deepspacestart
%Hauptpprogramm fr Startpositionsberechnung
% Hier eingeben
% Einheiten:
% Lnge:	1000km
% Zeit:		6 h
% Masse:	100 t
global Xstart UF m1 m2 m3 gam t v0 AE ort0 ErdPos MarsPos


UF=1/21.600;				%Geschwindigkeitsmastab
MF=1E-5;						%Massenmastab
LF=1E-6;						%Lngenmastab
TF=1/21600;					%Zeitmastab 
gam=-(LF^3/(MF*(TF.^2)))*6.673E-11;	%Gamma


m1=1.99*1E25;				%Sonnenmasse
m2=TF*5.97*1E19;			%Erdenmasse
m3=6.3879*1E18;			%Marsmasse
AE=149597.870;
T=[0 0];

% X: Alle Koordinaten festlegen (Ort und v festlegen)

%Sonne
X(1:2)=0;
X(3:4)=0;
%Erde
X(5:6)=[0.98*AE 0];
X(7:8)=[0 29.77/UF];
%Mars
X(9:10)=[1.38*AE 0];
X(11:12)=[0 25.36/UF];

t=[1:1:3000];	%fr 1 Marsumlauf

% ODe-Solver aufrufen
[T,Xstart,S]=ode113('derivsstart',t,X);
ErdPos=[Xstart(:,5),Xstart(:,6),Xstart(:,7),Xstart(:,8)];
MarsPos=[Xstart(:,9),Xstart(:,10),Xstart(:,11),Xstart(:,12)];

